# -*- coding: utf-8 -*-
from __future__ import print_function

import random
import requests
from datetime import datetime

ALLOWED_DC_NAMES = ('UGR', 'IVA', 'MYT', 'FOL', 'SAS-1', 'SAS-2', 'MAN-1', 'MAN-2')
TIME_FORMAT = '%Y-%m-%d %H:%M:%S'
DEFAULT_DC_LOCATION = 'ALL'
MAX_RETRIES = 3


def get_exclude(records):
    """Returns list of datacenters where maintenance mode is ebabled right now"""

    now = datetime.now()
    # uncomment for debug
    # now = datetime.strptime('2016-11-02 19:00:00', TIME_FORMAT);
    exclude = ()
    for record in records:
        time_start = datetime.strptime(record.get('time_start'), TIME_FORMAT)
        time_end = datetime.strptime(record.get('time_end'), TIME_FORMAT)
        if time_start <= now <= time_end:
            # dc format example: RU|IVA|IVNIT|IVA-7
            # we're interested in dc common name (IVA) and more specific one (IVA-7)
            dc = record.get('dc').split('|')
            exclude += (dc[1],)
            exclude += (dc[3],)
    return tuple(set(exclude))


def get_deploy_location():
    """
    Returns best available deploy location;

    could be specific datacenter or auto mode (ALL)
    """
    s = requests.Session()
    s.mount('https://', requests.adapters.HTTPAdapter(max_retries=MAX_RETRIES))
    r = requests.get('https://ro.admin.yandex-team.ru/api/downtime/dc.sbml?format=json')
    if r.status_code != 200:
        return DEFAULT_DC_LOCATION

    exclude = get_exclude(r.json())
    if exclude:
        return random.choice([loc for loc in ALLOWED_DC_NAMES if loc not in exclude])
    return DEFAULT_DC_LOCATION


if __name__ == '__main__':
    print(get_deploy_location())
