# -*- coding: utf-8 -*-

import re
import os
import logging

from pprint import pformat


def escape(env_dict):
    # Все значения в окружении должны быть сторкой
    return {k: str(v) for k, v in env_dict.iteritems()}


def snake_case(value):
    return re.sub('_?([0-9]+)', '_\\1', value.replace('-', '_'))


def export(env_dict):
    """Зайэскейпить и опубликовать в окружение переменные среды из словаря"""
    os.environ.update(escape(env_dict))


def from_vault(task):
    """Получить переменные среды из Sandbox Vault"""
    try:
        return task.vault.read_all_env()
    except AssertionError:  # vault недоступен на сервере
        return {}


def export_from_vault(task):
    """Получить и опубликовать переменные среды из Sandbox Vault"""
    logging.debug('exporting env variables from vault')

    export(from_vault(task))


def merge(env_dicts):
    """
    :param env_dicts: список словарей окружений, которые нужно смёржить.
    :type env_dicts: iterable
    :rtype: dict
    """
    merged_env_dict = {}
    for env in env_dicts:
        if env:
            merged_env_dict.update(env)

    return merged_env_dict


def log(task):
    """Логирует текущий environ со скрытием секретов"""
    vault_vars = from_vault(task)
    safe_vars = {}

    for key, value in os.environ.iteritems():
        if key in vault_vars:
            safe_vars[key] = '<vault record>'
        else:
            safe_vars[key] = value

    logging.debug('Environment variables: {}'.format(pformat(safe_vars)))


def merge_and_export(envs):
    export(merge(envs))
