# -*- coding: utf-8 -*-

import os
import stat
import itertools

from sandbox.projects.sandbox_ci.utils.process import run_process


def has_files(path):
    path = str(path)
    for root_path, dirs, files in os.walk(path):
        for path in itertools.chain(dirs, files):
            f_stat = os.lstat(os.path.join(root_path, path))
            if not stat.S_ISDIR(f_stat.st_mode):
                return True

    return False


def rmrf(dir_path):
    run_process(['rm', '-rf', dir_path])


def mkdir(dir_path):
    os.mkdir(dir_path)

    return dir_path
