# -*- coding: utf-8 -*-


def flatten(input_list):
    """
    :rtype: list
    """
    if input_list is None:
        return []

    if not isinstance(input_list, (list, tuple)):
        return [input_list]

    flatten_list = []

    for item in input_list:
        if isinstance(item, (list, tuple)):
            flatten_list.extend(flatten(item))
        else:
            flatten_list.append(item)

    return flatten_list


def every(input_list, fn):
    """
    :rtype: list
    """
    for i in input_list:
        if not fn(i):
            return False

    return True


def last(input_list):
    return input_list[-1]


def map_prop(input_list, prop):
    return map(lambda i: i[prop], input_list)
