# -*- coding: utf-8 -*-


def extract_pwc_metrics(hashes):
    """
    Traverse hashes object and collect "metrics" dict.
    :param hashes: Result object from prepare-working-copy.js script output
    :type hashes: dict
    :rtype: dict
    """
    result = {}
    stack = hashes.values()

    while stack:
        item = stack.pop()
        if isinstance(item, list):
            stack.extend(item)

        if isinstance(item, dict):
            metrics_dict = item.get('metrics', {})
            if metrics_dict:
                for key, value in metrics_dict.iteritems():
                    result[key] = result.get(key, 0) + value
            else:
                stack.extend(item.values())

    return result
