# -*- coding: utf-8 -*-

import time
import logging


def wait_for(fns, interval, timeout):
    formated_fn_ids = ', '.join(fns.keys())

    logging.info('Wait for {} with {} sec interval and {} sec timeout'.format(formated_fn_ids, interval, timeout))

    start_time = int(time.time())

    for fn_id, fn in fns.iteritems():
        logging.info('Wait for {}', fn_id)

        while fn() is not True:
            if int(time.time()) - start_time >= timeout:
                raise Exception('Wait timeout exceeded for {}'.format(formated_fn_ids))

            logging.info('"True" return value for {} is not met, will retry in {} sec'.format(fn_id, interval))
            time.sleep(interval)

        logging.info('"True" return value for {} is met'.format(fn_id))
