# -*- coding: utf-8 -*-

import sandbox.common.types.task as ctt

DEFAULT_PRIORITY = ('SERVICE', 'LOW')
RELEASE_PRIORITY = ('SERVICE', 'HIGH')

TASK_PRIORITIES = {
    'SandboxCiMergeQueue': ('SERVICE', 'NORMAL'),
    'SandboxCiMerge': ('SERVICE', 'NORMAL'),
    'SandboxCiTestRepeater': ('BACKGROUND', 'NORMAL'),
}


def get_priority(task):
    is_task_created_manually = task.Parameters.priority.cls == ctt.Priority.Class.USER

    priority = task.priority if hasattr(task, 'priority') else ()
    if priority and not is_task_created_manually:
        return ctt.Priority.make(priority)

    if getattr(task, 'is_release', None):
        return ctt.Priority.make(RELEASE_PRIORITY)

    is_task_priority_already_set = task.Parameters.priority != ctt.Priority.make(('BACKGROUND', 'LOW'))

    if is_task_priority_already_set and not is_task_created_manually:
        return task.Parameters.priority

    if task.__class__.__name__ in TASK_PRIORITIES:
        return ctt.Priority.make(TASK_PRIORITIES[task.__class__.__name__])

    return ctt.Priority.make(DEFAULT_PRIORITY)
