# coding=utf-8


class RefAdapter(object):
    def __init__(self, data):
        self._data = data

    @property
    def is_opened(self):
        return self._data.get('state') == 'open'

    @property
    def head_sha(self):
        raise Exception('"head_sha" should be implemented in descendants of "RefAdapter"')


class PullRequestAdapter(RefAdapter):
    @property
    def head_sha(self):
        return self._data.get('head').get('sha')


class ReviewRequestAdapter(RefAdapter):
    @property
    def head_sha(self):
        return self._data.get('active_diff_set', {}).get('arc_branch_heads', {}).get('from_id')
