# coding=utf-8

GITHUB_BRANCH_PREFIX = 'pull/'
ARCANUM_BRANCH_PREFIX = 'review/'


def strip_ref_prefix(ref):
    if is_github_ref(ref):
        return ref.replace(GITHUB_BRANCH_PREFIX, '')

    if is_arcanum_ref(ref):
        return ref.replace(ARCANUM_BRANCH_PREFIX, '')

    raise Exception('Invalid ref name {}, should start with {} or {}'.format(ref, GITHUB_BRANCH_PREFIX, ARCANUM_BRANCH_PREFIX))


def is_github_ref(ref):
    return ref.startswith(GITHUB_BRANCH_PREFIX)


def is_arcanum_ref(ref):
    return ref.startswith(ARCANUM_BRANCH_PREFIX)


def format_github_ref(pr_number):
    return '{prefix}{pr_number}'.format(prefix=GITHUB_BRANCH_PREFIX, pr_number=pr_number)
