# -*- coding: utf-8 -*-

GIT_RELEASE_BRANCH_PREFIX="release/"

ARC_RELEASE_BRANCH_PREFIXES = [
    "releases/frontend/web4/"
]


def is_git_release_branch(branch):
    return branch.startswith(GIT_RELEASE_BRANCH_PREFIX)


def is_arc_release_branch(branch):
    prefixes = filter_arc_release_branch_prefixes(branch)
    return len(prefixes) > 0


def filter_arc_release_branch_prefixes(branch):
    return filter(lambda prefix: branch.startswith(prefix), ARC_RELEASE_BRANCH_PREFIXES)


def remove_release_branch_prefix(branch):
    if is_git_release_branch(branch):
        return branch.replace(GIT_RELEASE_BRANCH_PREFIX, "", 1)

    if is_arc_release_branch(branch):
        prefixes = filter_arc_release_branch_prefixes(branch)
        if prefixes:
            return branch.replace(prefixes[0], "", 1)

    return branch
