# -*- coding: utf-8 -*-

import os
import logging

from sandbox.projects.sandbox_ci.utils.process import run_process


common_mksquashfs_options = ['-no-progress', '-no-recovery', '-comp', 'lzo', '-b', '4K']


def mksquashfs(input, output, work_dir=os.getcwd(), options=[]):
    logging.info('Packing {} into {}'.format(input, output))
    run_process(
        ['mksquashfs', input, output] + common_mksquashfs_options + options,
        work_dir=work_dir,
        log_prefix=os.path.basename(output)
    )
