# -*- coding: utf-8 -*-

import re

TASK_ID_PARSE_REG_EXP = re.compile(r'[A-Z]+-\d+')


def parse_issue_keys(titles):
    issue_keys = []

    for title in titles:
        issue_keys += TASK_ID_PARSE_REG_EXP.findall(title)

    return list(set(issue_keys))
