# -*- coding: utf-8 -*-

from sandbox.projects.sandbox_ci.utils.process import run_process


def compress_static(static_path):
    run_process([
        'find', static_path, '-type', 'f', '|',
        'xargs', '-n1', '-P10', '-I{}', 'bash', '-c', '\'',
        # Плейсхолдер в `I` работает только с первыми 255 байтами,
        # чтобы обходить данные ограничение было решено
        # присвоить путь файла в переменной.
        'f="{}";'
        'zopfli', '--i15', '"$f";',
        'brotli', '--quality=11', '--force', '--output="$f.br"', '"$f";\''
    ])
