# -*- coding: utf-8 -*-

from aniso8601 import parse_datetime


class TaskHistory(object):

    def __init__(self, states):
        self._states = states
        # collect records transitions
        self._transitions = zip(states, states[1:])

    def get_transition_times_from(self, status):
        total = 0

        for (src_state, dest_state) in self._transitions:
            if src_state.get('status') == status:
                total += (parse_datetime(dest_state.get('time')) - parse_datetime(src_state.get('time'))).seconds

        return total

    def get_task_start_time(self):
        return self._states[0].get('time')

    def get_task_finish_time(self):
        return self._states[-1].get('time')

    def get_time_intervals(self, status):
        time_intervals = []

        for (src_state, dest_state) in self._transitions:
            if src_state.get('status') == status:
                time_intervals.append((
                    parse_datetime(src_state.get('time')),
                    parse_datetime(dest_state.get('time'))
                ))

        return time_intervals

    def get_task_statuses(self):
        return map(lambda s: s.get('status'), self._states)
