# -*- coding: utf-8 -*-

import json

from sandbox import common


class PoolSetFilter:
    def __init__(self, pool_config_data):
        self.map_filter = json.loads(pool_config_data)
        self.max_filter_time = self.cache_max_filter_time()

    def get_pool_list(self):
        pools = []
        for i in self.map_filter:
            pools.append(i)
        return pools

    def is_enable(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['enable']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def is_important(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['important']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def get_max_rows_by_table(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['maxRowsByTable']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def get_min_rows_by_table(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['minRowsByTable']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def get_filter_time(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['filterTime']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def get_max_selected_tables(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['maxSelectedTables']
        else:
            raise common.errors.TaskFailure("No founded pool " + pool)

    def get_max_running_jobs(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['maxRunningJobs']
        else:
            return common.errors.TaskFailure("No founded pool " + pool)

    def get_skip_params(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['skipParams']
        else:
            return common.errors.TaskFailure("No founded pool " + pool)

    def get_allow_hosts(self, pool):
        if pool in self.map_filter:
            return self.map_filter[pool]['allowHosts']
        else:
            return common.errors.TaskFailure("No founded pool " + pool)

    def cache_max_filter_time(self):
        max_filter_time = 0
        for i in self.map_filter:
            max_filter_time = max(max_filter_time, self.map_filter[i]['filterTime'])
        return max_filter_time

    def get_max_filter_time(self):
        return self.max_filter_time
