# -*- coding: utf-8 -*-

import os
import logging


class ScraperOverYtChecker:
    def __init__(self, yt_table, yt, processed_table_path, status, telegram_sender):
        self.yt_table = yt_table
        self.yt = yt
        self.processed_table_path = processed_table_path
        self.status = status
        self.telegram_sender = telegram_sender

    def check_status(self):
        if 'simplified_operation_status' in self.status and self.status['simplified_operation_status'] == 'completed' and 'final_status' in self.status and self.status['final_status'] == 'completed':
            return True
        return False

    def check_output_table(self):
        output_table_path = self.yt_table.get_output_table_path()
        input_table_path = self.yt_table.get_input_table_path()

        if not self.yt.exists(output_table_path):
            self.telegram_sender.send('Does not exist output table {table}'.format(table=output_table_path))
            return False

        if not self.yt.exists(output_table_path):
            self.telegram_sender.send('Does not exist input table {table}'.format(table=input_table_path))
            return False

        try:
            output_rows_count = self.yt.get(os.path.join(output_table_path, '@row_count'))
            input_rows_count = self.yt.get(os.path.join(input_table_path, '@row_count'))

            if output_rows_count != input_rows_count:
                self.telegram_sender.send('Input rows count {0} and output rows count {1} are not equal in {2}!'.format(input_rows_count, output_rows_count, self.yt_table.get_working_directory()))
        except BaseException as e:
            logging.info(e)
            self.telegram_sender.send('{input_table} or {ouput_table} are not have row_count'.format(input_table=input_table_path, ouput_table=output_table_path))
            return False
        else:
            return True

    def check_from_processed_table(self):
        query = '* from [{0}] where id = \"{1}\"'.format(self.processed_table_path, self.yt_table.get_id())
        logging.info(query)
        row = list(self.yt.select_rows(query))[0]
        return row['final_status'] == 'completed'

    def check(self):
        return self.check_output_table()
