# -*- coding: utf-8 -*-

import logging
import time
import json
import requests

from sandbox import common


class ScraperOverYtDownloadQueries:
    def __init__(self, soy_api, telegram_sender, token):
        self.rows = []
        self.soy_api = soy_api
        self.sended = set()
        self.telegram_sender = telegram_sender
        self.token = token

    def send_and_add_by_row(self, table):
        retries = 5
        while retries > 0:
            answer = self.create_request(table)
            if answer.status_code == 200:
                break
            else:
                logging.info('returned ' + str(answer.status_code))
            retries -= 1
            time.sleep(10)

        if answer.status_code == 200:
            self.sended.add(table.get_id())
        else:
            logging.info(table.get_id())
            logging.info(answer)
            err_msg = 'SOY API not work!'
            self.telegram_sender.send(err_msg)
            raise common.errors.TaskFailure(err_msg)

    def start(self):
        completed = []
        while True:
            to_delete = []
            for id_ in self.sended:
                resp = self.get_status(id_)
                try:
                    status = str(resp['operation_status'])
                except BaseException as err:
                    logging.info(err)
                    logging.info(resp)
                    err_msg = 'Operation_status not found'
                    self.telegram_sender.send(err_msg)
                    raise common.errors.TaskFailure(err_msg)
                logging.info(status + ' ' + id_)
                status_uri = self.soy_api + '/status?id=' + id_
                if status == 'completed':
                    completed.append(id_)
                    to_delete.append(id_)
                elif status == 'failed':
                    to_delete.append(id_)
                    logging.info('fail')

                if status not in ['completed', 'queued', 'running', 'running_return', 'running_move']:
                    self.telegram_sender.send('Download with id = {id} {status}.\n Status {uri}'.format(id=id_, status=status, uri=status_uri))

            for id_ in to_delete:
                self.sended.remove(id_)

            if not self.sended:
                break
            time.sleep(60)

    def create_request(self, table):
        answer = requests.post(self.soy_api + '/create', data=json.dumps(table.get_spec()), headers={"Authorization": "OAuth " + self.token})
        logging.info('row_id = ' + table.get_id())
        return answer

    def get_status(self, t_id):
        response = requests.get(self.soy_api + '/status?id=' + t_id)
        logging.info(response.text)
        return response.json()

    def abort_download(self, t_id):
        response = requests.get(self.soy_api + '/abort?id=' + t_id)
        return response.json()

    def abort_all(self):
        for id_ in self.sended:
            self.abort_download(id_)
