# -*- coding: utf-8 -*-

import os


class YtTable:
    def __init__(self, rows, path_to_create, yt, pool):
        self.rows = rows
        self.yt = yt
        self.path_to_create = path_to_create
        self.output_table_path = ''
        self.t_id = ''
        self.operation_id = ''
        self.working_directory = ''
        self.pool = pool
        self.spec = ''

    def create_input_table(self):
        self.yt.write_table(self.path_to_create, self.rows, raw=False)

    def set_id(self, t_id):
        self.t_id = t_id

    def get_id(self):
        return self.t_id

    def set_operation_id(self, operation_id):
        self.operation_id = operation_id

    def get_operation_id(self):
        return self.operation_id

    def set_working_directory(self, working_directory):
        self.working_directory = working_directory

    def get_working_directory(self):
        return self.working_directory

    def get_input_table_path(self):
        return os.path.join(self.working_directory, 'input_table')

    def get_output_table_path(self):
        return os.path.join(self.working_directory, 'output_table')

    def get_error_table_path(self):
        return os.path.join(self.working_directory, 'error_table')

    def set_pool(self, pool):
        self.pool = pool

    def get_pool(self):
        return self.pool

    def set_spec(self, spec):
        self.spec = spec

    def get_spec(self):
        return self.spec

    def change_spec(self, key, value):
        self.spec[key] = value

    def get_value_from_spec(self, key):
        return self.spec[key]

    def has_value_in_spec(self, key):
        if key in self.spec:
            return True
        return False
