# -*- coding: utf-8 -*-

import logging
import requests


class TelegramSender:
    def __init__(self, rm_token, chat_id):
        self.rm_token = rm_token
        self.chat_id = chat_id

    def send(self, message):
        telegram_api = "https://api.telegram.org/bot{0}/sendMessage".format(self.rm_token)
        req = requests.post(
            telegram_api,
            json={
                "chat_id": self.chat_id,
                "text": message
            },
        )
        logging.info(req.json())
