from sandbox import common
from sandbox import sdk2
from sandbox.projects.sdc.common_tasks.PrepareTask import PrepareTask
from sandbox.projects.sdc.common import constants


class PreparePackage(PrepareTask):
    PACKAGE_VERSION_RESOLVE_BUILD_CONF = 'Selfdriving_2_Docker_GetPackageVersion'
    PACKAGE_VERSION_RESOLVE_BUILD_CONF_ARC = 'Selfdriving_2_Docker_GetPackageVersion_Arc'
    PACKAGE_VERSION_RESOLVE_BUILD_WAIT_TIME = 2 * 60

    class Parameters(PrepareTask.Parameters):
        branch_or_commit = sdk2.parameters.String(
            'Branch or commit for sdc package', required=True)

        # Task Service parameters
        kill_timeout = 15 * 60  # Set 15 min kill timeout

    description = 'Prepare sdc package from given branch or commit'

    def _get_package_version_from_task(self, build_id):
        try:
            build_props = self._get_build_resulting_props(build_id)
            for p in build_props:
                if p.attrib['name'] == 'package_version':
                    return p.attrib.get('value')
            self.LOGGER_IMPORTANT.debug('Cannot get package_version from resulting props task %s', build_id)
            raise common.errors.TaskFailure(
                'Cannot get package_version from resulting props task {}'.format(build_id))
        except Exception as e:
            self.LOGGER_IMPORTANT.exception(
                'Cannot get package version from task %s: %s.',
                build_id, repr(e)
            )
            raise common.errors.TaskFailure(
                'Cannot get package version from task {}'.format(build_id))

    def _resolve_version_on_teamcity(self, branch, commit):
        with self.memoize_stage.start_teamcity_resolve_package_version:
            self.Context.teamcity_resolve_package_version_id = self._trigger_build_on_teamcity(
                build_conf=self._build_conf_package_version(),
                branch=branch,
                last_changes=commit)
            raise sdk2.WaitTime(self.PACKAGE_VERSION_RESOLVE_BUILD_WAIT_TIME)
        self._check_teamcity_task_status(self.Context.teamcity_resolve_package_version_id,
                                         self.PACKAGE_VERSION_RESOLVE_BUILD_WAIT_TIME)
        return self._get_package_version_from_task(self.Context.teamcity_resolve_package_version_id)

    def _build_conf_package_version(self):
        if self.Parameters.vcs_type == constants.VCS_ARC:
            return self.PACKAGE_VERSION_RESOLVE_BUILD_CONF_ARC
        else:
            return self.PACKAGE_VERSION_RESOLVE_BUILD_CONF

    def on_execute(self):
        with self.memoize_stage.resolve_commit_or_branch:
            self.Context.contains_branch = False
            self.Context.package_branch = None
            self.Context.package_commit = None
            (self.Context.contains_branch, self.Context.package_branch,
             self.Context.package_commit) = self._contains_branch()
        assert self.Context.package_commit
        self.Context.package_version = self._resolve_version_on_teamcity(
            self.Context.package_branch, self.Context.package_commit)
