import logging

from sandbox import common
from sandbox import sdk2

from . import teamcity


class SdcCheckAccess(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Access parameters') as access_block:
            teamcity_token_vault_name = sdk2.parameters.String(
                'Teamcity token vault name',
                default='robot-nosecone-teamcity-token')

    def on_execute(self):
        logging.info('Checking access tokens')
        failed_services = set()
        failed_tokens = []
        try:
            teamcity_token_name = self.Parameters.teamcity_token_vault_name
            teamcity_token_value = sdk2.Vault.data(teamcity_token_name)
            if not teamcity.check_token(teamcity_token_name, teamcity_token_value):
                failed_services.add('Teamcity')
                failed_tokens.append('Teamcity by ' + teamcity_token_name)
        except:
            logging.exception('on_execute() has died')
            raise
        else:
            if len(failed_tokens) == 0:
                logging.info('Every access is checked successfully')
            else:
                logging.error('Some services are not available: %r', failed_services)
                logging.error('Some tokens are either not checked or bad: %r', failed_tokens)
                raise common.errors.TaskFailure(
                    '{} services unavailable or {} access denied'
                    .format(', '.join(failed_services), ', '.join(failed_tokens)),
                )
