import logging

import requests

from sandbox.projects.sdc.common.teamcity import TeamcityClient


def check_token(token_name, token_value):
    logging.info('Checking Teamcity API access')
    ok = False
    try:
        status_code = TeamcityClient.with_oauth(token_value).check_access()
    except requests.exceptions.ConnectionError as e:
        logging.error('Teamcity API connection error: %s', e)
    except requests.exceptions.RequestException as e:
        logging.error('Teamcity API request error: %s', e)
    except:
        logging.exception('Teamcity API check_token()')
    else:
        ok = status_code == 200
        if ok:
            logging.info('Teamcity API is accessible.')
        else:
            logging.error('Teamcity API HTTP status code: %r', status_code)
    return ok
