import logging

from sandbox import sdk2
from sandbox.projects.sdc.common_tasks.BaseSdcTask import BaseSdcTask
from sandbox.sdk2 import yav

import sandbox.common.types.client as ctc

log = logging.getLogger(__name__)


class SdcAwsCloneBinariesCAS(BaseSdcTask):
    class Requirements(BaseSdcTask.Requirements):
        ram = 32 * 1024  # 32GB
        disk_space = 30 * 1024  # 30 GB
        client_tags = ctc.Tag.SSD

    class Parameters(BaseSdcTask.Parameters):
        vcs_steps_path = sdk2.parameters.String(
            'Path to 0.sh script to Run',
            default='aws_deploy_copy/binaries_cas',
        )
        binaries_versions = sdk2.parameters.List(
            'Binaries CAS Versions',
            default=[
                'car/tags/groups/sdg/sdc/midnight-dev',
                'sadr/tags/groups/sdg/sdc/midnight-dev',
            ],
        )
        foreign_aws_bucket = sdk2.parameters.String(
            'AWS Bucket name',
            default='sdc-deploy',
        )
        foreign_aws_endpoint_url = sdk2.parameters.String(
            'AWS Endpoint URL',
            default='https://s3.us-east-2.amazonaws.com',
        )
        foreign_aws_key_prefix_binaries = sdk2.parameters.String(
            'AWS Key Prefix: Binaries CAS',
            default='sdc-binaries/cas',
        )
        foreign_aws_key_prefix_resource_data = sdk2.parameters.String(
            'AWS Key Prefix: Resource Data',
            default='resources_data',
        )
        foreign_aws_key_prefix_resource_info = sdk2.parameters.String(
            'AWS Key Prefix: Resource Info referenced from .meta',
            default='resources_info',
        )
        foreign_aws_yav_secret = sdk2.parameters.String(
            'AWS access_key_id and secret_access_key YAV id',
            default='sec-01fx317z32txnjjacp2yktpn7n',
        )
        copy_debug = sdk2.parameters.Integer(
            'Number of --debug flags to infra.sdcbinaries copy scripts',
            default=0,
        )

    def on_prepare(self):
        super(SdcAwsCloneBinariesCAS, self).on_prepare()
        secrets = yav.Yav(
            sdg_aws_sdc_deploy_publisher=yav.Secret(self.Parameters.foreign_aws_yav_secret),
        )
        self.sdg_aws_sdc_deploy_publisher = secrets.sdg_aws_sdc_deploy_publisher

    def secret_list(self):
        r = super(SdcAwsCloneBinariesCAS, self).secret_list()
        # no need to hide access_key_id
        r.append(self.sdg_aws_sdc_deploy_publisher['secret_access_key'])
        return r

    def get_non_overridable_env_variables(self):
        r = super(SdcAwsCloneBinariesCAS, self).get_non_overridable_env_variables()
        r.update({
            'T__BINARIES_VERSIONS': ' '.join(self.Parameters.binaries_versions),
            'T__COPY_DEBUG': ' '.join(['--debug'] * self.Parameters.copy_debug),
            'T__FOREIGN_S3_ACCESS_KEY_ID': self.sdg_aws_sdc_deploy_publisher['access_key_id'],
            'T__FOREIGN_S3_BUCKET': self.Parameters.foreign_aws_bucket,
            'T__FOREIGN_S3_ENDPOINT_URL': self.Parameters.foreign_aws_endpoint_url,
            'T__FOREIGN_S3_KEY_PREFIX__BINARIES_CAS':
                self.Parameters.foreign_aws_key_prefix_binaries,
            'T__FOREIGN_S3_KEY_PREFIX__RESOURCE_DATA':
                self.Parameters.foreign_aws_key_prefix_resource_data,
            'T__FOREIGN_S3_KEY_PREFIX__RESOURCE_INFO':
                self.Parameters.foreign_aws_key_prefix_resource_info,
            'T__SECRET__FOREIGN_S3_SECRET_ACCESS_KEY':
                self.sdg_aws_sdc_deploy_publisher['secret_access_key'],
        })
        return r
