from sandbox import sdk2

from sandbox.projects.sdc.SdcBuild import SdcBuild


class SdcBazelTests(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        disk_space = 340 * 1024  # 340 GB

    class Parameters(SdcBuild.Parameters):
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tests/bazel_tests')

    def get_default_env_variables(self):
        envs = super(SdcBazelTests, self).get_default_env_variables()
        envs.update({
            'T__BAZEL_TEST_BAGS': '1',
        })
        return envs
