from sandbox import sdk2

from sandbox.projects.sdc.SdcBazelTests import SdcBazelTests


class SdcBazelTestsBazelDiff(SdcBazelTests):
    class Requirements(SdcBazelTests.Requirements):
        disk_space = 250 * 1024  # 250 GB

    class Parameters(SdcBazelTests.Parameters):
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tests/bazel_tests')

        build_args = sdk2.parameters.String('Build arguments',
                                            default='--jobs=1000')

    def get_default_env_variables(self):
        envs = super(SdcBazelTestsBazelDiff, self).get_default_env_variables()
        envs.update({
            'T__USE_BAZEL_DIFF': '--use-bazel-diff',
            'T__BAZEL_REMOTE_EXECUTION_ENABLE': '1',
        })
        return envs
