from sandbox import sdk2
import os

import sandbox.common.types.client as ctc

from sandbox.projects.sdc.common_tasks.BaseSdcTaskWithDocker import BaseSdcTaskWithDocker
from sandbox.projects.sdc.resource_types import SdcFrequentBazelArtifacts
from sandbox.projects.sdc.common.parameters import LastFrequentBazelArtifacts

from sandbox.common.types.resource import State


class SdcBuild(BaseSdcTaskWithDocker):
    # Bazel report remains here for backward compatibility
    # This artifact replaced with ci_report.html in trunk
    # TODO: remove later
    BAZEL_REPORT_HTML = 'bazel_report.html'

    class Requirements(BaseSdcTaskWithDocker.Requirements):
        cores = 32
        ram = 80 * 1024  # 80GB
        disk_space = 340 * 1024  # 340 GB
        client_tags = ctc.Tag.SSD

    class Parameters(BaseSdcTaskWithDocker.Parameters):
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tc_build/build_sdc_and_pytest')
        upload_porto = sdk2.parameters.Bool('Upload porto layers after build or no',
                                            default=True)
        frequent_bazel_artifacts = LastFrequentBazelArtifacts(
            'Most frequent ac/cas artifacts'
        )

    def get_default_env_variables(self):
        envs = super(SdcBuild, self).get_default_env_variables()
        envs['T__UPLOAD_PORTO_LAYER'] = 'true' if self.Parameters.upload_porto else 'false'
        envs['T__PY3_ONLY'] = '1'  # TODO: remove after master-lts switch
        return envs

    def on_resources_ready(self, uploaded_resources):
        ci_report_resource = None
        for r in uploaded_resources:
            file_name = getattr(r, 'file_name', None)
            if self.is_ci_report(file_name):
                ci_report_resource = r
                break

        if not ci_report_resource:
            return

        # Report bazel report url
        url = ci_report_resource.http_proxy
        task_info = """<a href="{}">Show CI report</a>""".format(url)
        self.set_info(task_info, do_escape=False)

    def is_ci_report(self, file_name):
        return file_name in {self.BAZEL_REPORT_HTML, self.CI_REPORT_HTML}

    @property
    def artifacts_with_direct_link(self):
        r = super(SdcBuild, self).artifacts_with_direct_link
        patterns = set()
        patterns.update(r)
        patterns.add('**/{}'.format(self.BAZEL_REPORT_HTML))
        return patterns

    def on_prepare(self):
        result = super(SdcBuild, self).on_prepare()
        resource = self.Parameters.frequent_bazel_artifacts

        if not resource:
            resource = SdcFrequentBazelArtifacts.find(
                state=(State.READY, ),
                limit=1,
            ).first()

        if not resource:
            return result

        yandexsdc_root = self.get_yandexsdc_path()
        data = sdk2.ResourceData(resource)
        self.logger.info(
            'Resource %d downloaded to %s',
            resource.id,
            data.path,
        )

        prefix = str(data.path).rstrip('/') + '/'  # ensure slash at the end for
        for dirpath, dirnames, filenames in os.walk(prefix):
            for filename in filenames:
                src_path = os.path.join(dirpath, filename)
                suffix = src_path[len(prefix):]
                dst_path = os.path.join(yandexsdc_root, 'bazel_cache/cache/storage', suffix)
                dst_dir = os.path.dirname(dst_path)

                if not os.path.exists(dst_dir):
                    os.makedirs(dst_dir, mode=0o777)
                os.symlink(src_path, dst_path)

        return result
