from sandbox import sdk2
from sandbox.projects.sdc.SdcBuild import SdcBuild


class SdcBuildASAN(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        disk_space = 240 * 1024  # 240 GB

    class Parameters(SdcBuild.Parameters):
        build_type = sdk2.parameters.String('Build type', default='DEBUG')
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tc_build/build_sdc_asan_no_upload')

    def get_default_env_variables(self):
        envs = super(SdcBuildASAN, self).get_default_env_variables()
        envs.update({
            'T__BAZEL_REMOTE_EXECUTION_ENABLE': '1',
        })
        return envs
