from sandbox import sdk2
from sandbox import common

from sandbox.projects.sdc.PrepareBinariesResource import PrepareBinariesResource
from sandbox.projects.sdc.porto_helper.AbstractSdcBuildPortoLayer import AbstractSdcBuildPortoLayer


class SdcBuildBinariesPortoLayer(AbstractSdcBuildPortoLayer):
    class Parameters(AbstractSdcBuildPortoLayer.Parameters):
        ctest_disabled = sdk2.parameters.Bool(
            'Run without ctests', required=True, default_value=False
        )
        build_sdc_tc_build_id = sdk2.parameters.Integer('Build SDC teamcity build id to reuse for binaries', required=False)
        build_sdc_sandbox_task_id = sdk2.parameters.Integer('Build SDC sandbox build id to reuse for binaries', required=False)

    def create_preparation_task(self, sdc_important_logs_resource):
        branch_or_commit = ''
        if self.Parameters.branch:
            branch_or_commit += self.Parameters.branch + ','
        branch_or_commit += self.Parameters.commit
        return PrepareBinariesResource(
            self, branch_or_commit=branch_or_commit,
            ctest_disabled=self.Parameters.ctest_disabled,
            important_logs_parent_resource=sdc_important_logs_resource,
            build_sdc_tc_build_id=self.Parameters.build_sdc_tc_build_id,
            build_sdc_sandbox_task_id=self.Parameters.build_sdc_sandbox_task_id,
            prepare_sdc_binaries_archive=False,
            bb_server_url=self.Parameters.bb_server_url,
            vcs_type=self.Parameters.vcs_type,
        )

    def build_porto_layer(self):
        # We are not actually building porto layer, since it was built inside Build SDC (SDC-61731)
        # But we need to make sure it already exists in YT
        with self.memoize_stage.second_check_existence:
            self.check_for_success(self.Context.preparation_task_id)
            if not self.porto_layer_exists():
                raise common.errors.TaskFailure(
                    "Porto layer {} wasn't built inside Build SDC or was built for different commit".format(
                        self.Parameters.yt_path
                    )
                )
