from sandbox import sdk2
from sandbox.projects.sdc.SdcBuild import SdcBuild


class SdcBuildDebug(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        disk_space = 230 * 1024  # 230 GB

    class Parameters(SdcBuild.Parameters):
        build_type = sdk2.parameters.String('Build type', default='DEBUG')
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tc_build/build_sdc_debug_no_upload')
        build_args = sdk2.parameters.String('Build arguments',
                                            default='--jobs=1000')

    def get_default_env_variables(self):
        envs = super(SdcBuildDebug, self).get_default_env_variables()
        envs.update({
            'T__BAZEL_REMOTE_EXECUTION_ENABLE': '1',
        })
        return envs
