from sandbox.projects.sdc.SdcBuild import SdcBuild


class SdcBuildLauncher(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        disk_space = 160 * 1024  # 160 GB

    def get_buildsdcript_env_variables(self):
        envs = super(SdcBuildLauncher, self).get_buildsdcript_env_variables()
        envs.update({
            'T__SECRET_QTOOLS_TOKEN': self.qtools_token,
            'T__YA_TOKEN': self.ya_token,
            'T__DCTL_YP_TOKEN': self.dctl_yp_token,
            'T__AWACS_OAUTH_TOKEN': self.awacs_oauth_token,
            'T__SECRET__WWW_BB_TOKEN': self.www_bb_token,
            'T__SECRET__WWW_ST_TOKEN': self.www_st_token,
            'T__EMERGENCY_OAUTH_TOKEN': self.emergency_token,
            'T__TAXIMETER_OAUTH_TOKEN': self.taximeter_token,
        })
        return envs
