import sandbox.common.types.client as ctc

from sandbox import common
from sandbox.sdk2.os import enable_turbo_boost, disable_turbo_boost
from sandbox.projects.sdc.SdcBuild import SdcBuild


class SdcBuildPerfCtests(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        client_tags = ctc.Tag.INTEL_GOLD_6230

    def check_turbo_boost(self):
        with open('/sys/devices/system/cpu/intel_pstate/no_turbo', 'r') as f:
            turbo_boost_off = int(f.readline().rstrip())
            if turbo_boost_off:
                return
            else:
                raise common.errors.TaskFailure('Turbo Boost is enabled!')

    def on_execute(self):
        try:
            disable_turbo_boost()
            self.check_turbo_boost()
            super(SdcBuild, self).on_execute()
        except Exception as e:
            raise e
        finally:
            enable_turbo_boost()
