# coding: utf-8

import logging
import urlparse
import urllib

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr

from sandbox.projects.sdc.resource_types import SdcRosbagDecoder
from sandbox.projects.sdc.resource_types import SdcRosbagDecodedJsonFile


class SdcDecodeRosbagFileFromMds(sdk2.Task):
    """
    This task should get rosbag files from MDS storage and decode them with special tool to json-files.
    """

    class Parameters(sdk2.Parameters):
        rosbag_file_url = sdk2.parameters.Url('Rosbag file URL', required=True)
        rosbag_decoder = sdk2.parameters.LastReleasedResource(
            'Rosbag decoder binary', resource_type=SdcRosbagDecoder, state=(ctr.State.READY, )
        )

    def on_execute(self):
        logging.info('Get rosbag decoder')
        rosbag_decoder_path = sdk2.ResourceData(self.Parameters.rosbag_decoder).path

        logging.info('Download file {} from MDS'.format(self.Parameters.rosbag_file_url))
        rosbag_filename = urlparse.urlsplit(self.Parameters.rosbag_file_url).path.replace('/', '_')
        rosbag_path = self.path(rosbag_filename)
        urllib.urlretrieve(str(self.Parameters.rosbag_file_url), str(rosbag_path))

        decodec_rosbag_filename = '{}.json'.format(rosbag_filename)
        decoded_rosbag_resource = sdk2.ResourceData(
            SdcRosbagDecodedJsonFile(
                self, 'decoded rosbag file from {}'.format(self.Parameters.rosbag_file_url), decodec_rosbag_filename)
        )

        logging.info('Decode from {} to {}'.format(rosbag_path, decoded_rosbag_resource.path))
        command = [
            str(rosbag_decoder_path),
            '--input', str(rosbag_path),
            '--output', str(decoded_rosbag_resource.path)
        ]
        with sdk2.helpers.ProcessLog(self, logger='rosbag_decode') as rosbag_decode_log:
            sp.Popen(command, stdout=rosbag_decode_log.stdout, stderr=rosbag_decode_log.stderr).wait()

        decoded_rosbag_resource.ready()
        logging.info('Rosbag file was successfully decoded and saved to {}'.format(decoded_rosbag_resource.path))
