from sandbox import sdk2
from sandbox import common
from sandbox.projects.sdc.SdcBuild import SdcBuild
from sandbox.projects.sdc.common import binaries_api
from sandbox.projects.sdc.common.yt_helpers import create_clusters, check_yt_path_existence, YT_VERSION
from sandbox.sandboxsdk.environments import PipEnvironment

import sandbox.common.types.client as ctc


class SdcDeployPorto(SdcBuild):
    class Requirements(SdcBuild.Requirements):
        disk_space = 115 * 1024  # 115 GB
        client_tags = ctc.Tag.HDD | ctc.Tag.SSD
        environments = (
            PipEnvironment('yandex-yt', YT_VERSION),
        )

    class Parameters(SdcBuild.Parameters):
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='sdc_deploy/porto')
        bazel_target = sdk2.parameters.String('Bazel target for building light porto layer', required=True)
        clusters = sdk2.parameters.List('Clusters for uploading light porto layer', default=['hahn'])

    def get_default_env_variables(self):
        envs = super(SdcBuild, self).get_default_env_variables()
        envs['T__CLUSTERS'] = ' '.join(self.Parameters.clusters)
        envs['T__BAZEL_TARGET'] = self.Parameters.bazel_target
        return envs

    def on_build_script_success(self):
        super(SdcBuild, self).on_build_script_success()
        # ensure, that we actually built porto layer, and it has correct YT path
        porto_layers = binaries_api.get_porto_layers(
            working_dir=str(self.get_working_dir()), stripped=False, bazel_target=self.Parameters.bazel_target
        )["layers"]
        clusters = create_clusters(self.Parameters.clusters, self.yt_token)
        if not check_yt_path_existence(clusters, porto_layers[0]):
            raise common.errors.TaskFailure(
                "Porto layer {} wasn't built inside SDC_DEPLOY_PORTO or was built for different commit/target".format(
                    porto_layers[0]
                )
            )
