from sandbox import sdk2

from sandbox.projects.sdc.common_tasks.BaseSdcTask import BaseSdcTask
from sandbox.projects.sdc.common.aws import download_ci_and_binaries_from_s3
from sandbox.projects.sdc.common.aws import initialize_aws_credentials
from sandbox.projects.sdc.common.docker import login_to_docker, configure_docker
from sandbox.projects.sdc.common.utils import normalize_branch
from sandbox.projects.sdc.common.yt_helpers import initialize_yt_credentials

import sandbox.common.types.client as ctc


class SdcIsolateTests(BaseSdcTask):
    """ A task which runs isolated tests. https://st.yandex-team.ru/SDC-20302"""

    class Requirements(BaseSdcTask.Requirements):
        ram = 32 * 1024  # 32GB
        cores = 8
        disk_space = 75 * 1024  # 75 GB
        client_tags = ctc.Tag.SSD

    class Parameters(BaseSdcTask.Parameters):
        git_steps_archive_mds_url = sdk2.parameters.String('CI steps mds url')
        archive_path = sdk2.parameters.String('Archive path')
        binaries_mds_url = sdk2.parameters.String('Binaries url')
        build_types_for_statistics = sdk2.parameters.String('Build type for statistics')
        command = sdk2.parameters.String('Command to run in docker')
        image_latest_hash = sdk2.parameters.String('Docker image latest hash')
        retry_on_failure_mode = sdk2.parameters.String('Retry on failure mode')
        stats_upload_recipients = sdk2.parameters.String('Stats upload recipients')
        tarball_build_id = sdk2.parameters.String('Tarball build id')
        test_runner_args = sdk2.parameters.String('Test runner args')

    def get_buildsdcript_env_variables(self):
        envs = super(SdcIsolateTests, self).get_buildsdcript_env_variables()
        envs.update({
            'T__ARCHIVE_PATH': self.Parameters.archive_path,
            'T__BINARIES_MDS_URL': self.Parameters.binaries_mds_url,
            'T__BUILD_TYPES_FOR_STATISTICS': self.Parameters.build_types_for_statistics,
            'T__CH_SDC_MON_PASS': self.ch_password,
            'T__COMMAND': self.Parameters.command,
            'T__IMAGE_LATEST_HASH': self.Parameters.image_latest_hash,
            'T__RETRY_ON_FAILURE_MODE': self.Parameters.retry_on_failure_mode,
            'T__STATS_UPLOAD_RECIPIENTS': self.Parameters.stats_upload_recipients,
            'T__TARBALL_BUILD_ID': self.Parameters.tarball_build_id,
            'T__TEST_RUNNER_ARGS': self.Parameters.test_runner_args,
            'T__BRANCH': normalize_branch(self.Parameters.branch),
            'T__BUILD_ID': self.Parameters.teamcity_build_id
        })
        return envs

    def get_working_dir(self):
        return self.path()

    def on_execute(self):
        self.logger.info('Task {} started'.format(self.__class__.__name__))
        configure_docker(self)
        login_to_docker(self, self.Parameters.username, self.registry_token)
        initialize_aws_credentials(self.aws_key_id, self.aws_secret_key)
        download_ci_and_binaries_from_s3(
            self, self.Parameters.git_steps_archive_mds_url, self.Parameters.binaries_mds_url,
            self.aws_secret_key, self.aws_key_id
        )
        initialize_yt_credentials(self.yt_token)
        self.run_build_script()
        self.prepare_cleanup()
        self.logger.info('Task {} finished'.format(self.__class__.__name__))
