import logging

from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus

log = logging.getLogger(__name__)


class SdcLanesMapValidatorRelease(sdk2.Task):
    class Parameters(sdk2.Parameters):
        task_id_to_release = sdk2.parameters.Integer('Task ID to RELEASE', hint=True)

    def on_execute(self):
        self.server.release(
            task_id=self.Parameters.task_id_to_release,
            type=ReleaseStatus.STABLE,
            subject='Release lanes map validator for maps-editor.',
        )
