import logging

from sandbox import sdk2
from sandbox.projects.sdc.common_tasks.BaseSdcTaskWithDocker import BaseSdcTaskWithDocker

log = logging.getLogger(__name__)


class SdcLint(BaseSdcTaskWithDocker):
    class Requirements(BaseSdcTaskWithDocker.Requirements):
        cores = 32  # 4 is enough, 32 = avoid MULTISLOT agent
        ram = 16 * 1024  # 16 GB
        # TODO check real disk usage and decrease this number
        disk_space = 30 * 1024  # 30 GB

    class Parameters(BaseSdcTaskWithDocker.Parameters):
        vcs_steps_path = sdk2.parameters.String('Path to 0.sh script to Run',
                                                default='tc_build/lint')
