import logging

from sandbox import sdk2
from sandbox import common
from sandbox.projects.sandbox import sandbox_lxc_image
from sandbox.projects.sdc.resource_types import SdcLxcContainerCI

import sandbox.common.types.task as ctt


class SdcLxcContainerForCI(sdk2.Task):
    class Context(sdk2.Task.Context):
        build_task_id = 0

    def on_execute(self):
        with self.memoize_stage.fire_once:
            script = common.fs.read_file('resources/custom_script.sh')

            logging.info('Script: {}'.format(script))

            params = {
                sandbox_lxc_image.SandboxLxcImage.Parameters.ubuntu_release.name: 'bionic',
                sandbox_lxc_image.SandboxLxcImage.Parameters.custom_image.name: True,
                sandbox_lxc_image.SandboxLxcImage.Parameters.test_result_lxc.name: False,
                sandbox_lxc_image.SandboxLxcImage.Parameters.install_common.name: True,
                sandbox_lxc_image.SandboxLxcImage.Parameters.custom_script.name: script,
            }

            build_task = sandbox_lxc_image.SandboxLxcImage(
                self,
                description='Build LXC image with SDC CI-specific enviroment',
                resource_type=SdcLxcContainerCI.name,
                **params
            )
            self.Context.build_task_id = build_task.enqueue().id

            raise sdk2.WaitTask(
                self.Context.build_task_id,
                tuple(ctt.Status.Group.FINISH) + tuple(ctt.Status.Group.BREAK)
            )

        build_task = sdk2.Task[self.Context.build_task_id]
        if build_task.status != ctt.Status.SUCCESS:
            raise common.errors.TaskFailure(
                'Build image task failed, see child task for details')
