set -e

apt-get install -y yandex-internal-root-ca
apt-get --yes purge yandex-search-common-apt

tee /etc/apt/sources.list.d/sdc-sources.list <<EOF
deb https://dist.sdc.yandex.net/bionic stable/all/
deb https://dist.sdc.yandex.net/bionic stable/amd64/
deb https://dist.sdc.yandex.net/bionic testing/all/
deb https://dist.sdc.yandex.net/bionic testing/amd64/
deb https://dist.sdc.yandex.net/bionic unstable/all/
deb https://dist.sdc.yandex.net/bionic unstable/amd64/
EOF

apt-get update
apt-get install -y atop squashfs-tools pigz

apt-get install -y python3-urllib3=1.22-1ubuntu0.18.04.2

apt-get install -y sdc-pbuilder debmake python-setuptools python-pygit2 yandex-yt-python python-virtualenv

apt-get install -y python-psycopg2 python-jinja2 python-enum34 python-botocore python-boto3
apt-get install -y python-six python-requests python-psutil python-numpy

# Build tools
apt-get install -y nodejs=12.20.1-1nodesource1
apt-get install -y bazel=4.2.2-1+sdcbionic0 bazel-buildtools=2.2.1-1+sdcbionic2 bazel-diff=2.1.2-1+sdcbionic4
# Common python libraries
apt-get install -y python3-pip python3-six python3-ruamel.yaml python3-requests python3-boto3 python3-jinja2 python3-retrying python3-glob2
apt-get install -y python3-termcolor python3-pygit2 python3-numpy python3-pandas python3-dateutil python3-click
apt-get install -y python3-protobuf python3-shapely python3-simplejson
# Yandex libs
apt-get install -y yandex-yt-python3 yandex-yt-python3-driver-rpc yandex-yt-python3-yson
apt-get install -y yandex-yql-python3 python3-startrek-client
# Kikimr (Logbroker)
apt-get install -y python3-tvm2 python3-kikimrclient python3-ticket-parser2
# PIP3 libraries
pip3 install pytz
pip3 install wcmatch


apt-get update
apt-get --yes install curl git python-pip software-properties-common apt-transport-https bc libffi-dev
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | apt-key add -
add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu \
   xenial \
   stable"
apt-get update
apt-get --yes install docker-ce

echo 'DOCKER_CONFIG=/etc/docker/.docker' | tee -a /etc/default/docker

cat >> /etc/environment << EOF
REQUESTS_CA_BUNDLE="/etc/ssl/certs/ca-certificates.crt"
EOF

mkdir -p /etc/iptables
cat > /etc/iptables/rules.v6 << EOF
*filter
:INPUT ACCEPT [176:22921]
:FORWARD ACCEPT [0:0]
:OUTPUT ACCEPT [29:5356]
COMMIT
*nat
:PREROUTING ACCEPT [101:8396]
:INPUT ACCEPT [10:720]
:OUTPUT ACCEPT [80:6923]
:POSTROUTING ACCEPT [80:6923]
-A POSTROUTING -s fd00::/8 -j MASQUERADE
COMMIT
EOF

mkdir -p /etc/docker
cat > /etc/docker/daemon.json << EOF
{
    "ipv6": true,
    "fixed-cidr-v6": "fd00::/8",
    "ip-forward": true
}
EOF

usermod -aG docker sandbox
usermod -aG docker zomb-sandbox

mkdir -p /etc/sandbox -m 755
cat > /etc/sandbox/on_task_start << EOF
test -e /dev/kvm || mknod /dev/kvm c 10 232
echo "
{
 \"ipv6\": true,
 \"fixed-cidr-v6\": \"fd00::/8\",
 \"ip-forward\": true,
 \"data-root\": \"$1\"
}" > /etc/docker/daemon.json
EOF

dpkg -l

chgrp docker /etc/docker/daemon.json

cat > /etc/sudoers.d/docker << EOF
%docker ALL = NOPASSWD: /usr/sbin/service docker restart
%docker ALL = NOPASSWD: /usr/bin/tee
%docker ALL = NOPASSWD: /bin/chown
EOF

chmod 440 /etc/sudoers.d/docker

cat > /etc/fuse.conf << EOF
# /etc/fuse.conf - Configuration file for Filesystem in Userspace (FUSE)

# Set the maximum number of FUSE mounts allowed to non-root users.
# The default is 1000.
#mount_max = 1000

# Allow non-root users to specify the allow_other or allow_root mount options.
user_allow_other
EOF
