import logging
import os

from sandbox import sdk2
from sandbox.projects.sdc.common import utils
from sandbox.projects.sdc.common_tasks.BaseSdcTask import BaseSdcTask

import sandbox.common.types.client as ctc


class SdcPrComposite(BaseSdcTask):
    """ A task which runs Pr Composite in SANDBOX """

    class Requirements(BaseSdcTask.Requirements):
        ram = 8 * 1024  # 8GB
        cores = 2
        disk_space = 75 * 1024  # 75 GB
        client_tags = ctc.Tag.SSD

    class Parameters(BaseSdcTask.Parameters):
        git_step_post_run = sdk2.parameters.String(
            'Step path to post_run_script', default='misc/pr_composite_post_run')

    def on_failure(self, prev_status):
        logging.info('Task {} failure. Going to run post_run_script()'.format(self.__class__.__name__))
        self.post_run_script()
        super(SdcPrComposite, self).on_failure(prev_status)

    def on_break(self, prev_status, status):
        logging.info('Task {} break. Going to run post_run_script()'.format(self.__class__.__name__))
        self.post_run_script()
        super(SdcPrComposite, self).on_break(prev_status, status)

    def post_run_script(self):
        # https://st.yandex-team.ru/SDC-58963#60408a4b2810894b9a54ee24
        working_dir = self.get_working_dir()
        if os.path.exists(os.path.join(str(working_dir), 'ci/teamcity', self.Parameters.git_step_post_run)):
            with utils.create_venv() as venv:
                logging.info('Task {}. Step 2 post_run_script'.format(self.__class__.__name__))
                utils.configure_env(venv)
                self.run_build_script(self.Parameters.git_step_post_run)
                logging.info('Task {}. Step 2 post_run_script finished'.format(self.__class__.__name__))
