import logging

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.sdc.common.constants import ROBOT_SDC_CI_SECRET_ID
from sandbox.projects.sdc.common.teamcity import TeamcityClient
from sandbox.projects.sdc.common.yt_helpers import get_yt_client, YT_VERSION
from sandbox.sdk2 import yav


class SdcStopTeamcityBuilds(sdk2.Task):
    TEAMCITY_BUILDS_FROM_NIRVANA_TABLE = '//home/selfdriving/ci/teamcity_builds_from_nirvana'
    SELECT_TC_BUILDS = '* from [{}] where nirvana_workflow_id="{}"'

    class Requirements(sdk2.Requirements):
        environments = (PipEnvironment('yandex-yt', YT_VERSION),)

    class Parameters(sdk2.Parameters):
        nirvana_workflow_id = sdk2.parameters.String('Nirvana worfkflow id started builds')

    def on_prepare(self):
        secrets = yav.Yav(robot_sdc_ci=yav.Secret(ROBOT_SDC_CI_SECRET_ID))
        teamcity_token = secrets.robot_sdc_ci['token.teamcity']
        yt_token = secrets.robot_sdc_ci['token.yt']
        self.tc_client = TeamcityClient.with_oauth(teamcity_token)
        self.yt_client = get_yt_client('hahn', yt_token)

    def select_builds(self, nirvana_workflow_id):
        res = list(self.yt_client.select_rows(
            self.SELECT_TC_BUILDS.format(self.TEAMCITY_BUILDS_FROM_NIRVANA_TABLE, nirvana_workflow_id),
            format='json'
        ))
        rows = []
        for r in res:
            rows.append({
                'nirvana_workflow_id': r['nirvana_workflow_id'],
                'teamcity_build_id': r['teamcity_build_id']
            })
        return rows

    def on_execute(self):
        builds = self.select_builds(self.Parameters.nirvana_workflow_id)
        build_ids = map(lambda b: b['teamcity_build_id'], builds)
        logging.info('Builds to cancel: {}'.format(build_ids))
        for build_id in build_ids:
            self.tc_client.cancel_build(build_id, 'Cancelled by sandbox task with id {}'.format(self.id))
        self.yt_client.delete_rows(self.TEAMCITY_BUILDS_FROM_NIRVANA_TABLE, builds, format='json')
