# coding: utf-8

from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.sandboxsdk import environments


class SdcUpdateBothLayersSymlinks(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('YT symlinks parameters') as yt_symlinks_block:
            cluster = sdk2.parameters.String('Target YT cluster', required=True)
            yt_link_latest_packages_path = sdk2.parameters.String('YT link latest packages cypress path', required=True)
            yt_link_weekly_packages_path = sdk2.parameters.String('YT link weekly packages cypress path', required=True)
            yt_link_latest_binaries_path = sdk2.parameters.String('YT link latest binaries cypress path', required=True)
            yt_link_weekly_binaries_path = sdk2.parameters.String('YT link weekly binaries cypress path', required=True)
            yt_token_vault_name = sdk2.parameters.String('YT token vault name', required=False,
                                                         default='sdc-yt-token')

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
        )
        client_tags = ctc.Tag.GENERIC

    description = 'Update weekly symlinks to latest porto layers'

    def _get_yt_client(self):
        from yt.wrapper import YtClient
        return YtClient(self.Parameters.cluster, token=sdk2.Vault.data(self.Parameters.yt_token_vault_name))

    def on_execute(self):
        yt_client = self._get_yt_client()
        if not yt_client.exists(self.Parameters.yt_link_latest_packages_path) or not yt_client.exists(self.Parameters.yt_link_latest_binaries_path):
            return

        yt_client.link(yt_client.get(self.Parameters.yt_link_latest_packages_path + '/@path'),
                       self.Parameters.yt_link_weekly_packages_path,
                       recursive=True, force=True)
        yt_client.link(yt_client.get(self.Parameters.yt_link_latest_binaries_path + '/@path'),
                       self.Parameters.yt_link_weekly_binaries_path,
                       recursive=True, force=True)
