from six.moves.urllib.parse import urljoin

from sandbox.projects.sdc.common import session

ARCANUM_DEFAULT_REPO = 'arc_vcs'
ARCANUM_DEFAULT_URL = 'https://a.yandex-team.ru'


class ArcanumClient:
    def __init__(self,
                 token,
                 repo=ARCANUM_DEFAULT_REPO,
                 url=ARCANUM_DEFAULT_URL):
        self.session = session.create_session()
        self.auth_headers = {'Authorization': 'OAuth {}'.format(token)}
        self.server_url = url
        self.rest_api_v1_url = urljoin(self.server_url, 'api/v1/repos/{}/'.format(repo))

    def get_commit_from_branch_or_commit(self, branch_or_commit):
        """
        Returns last commit on branch if branch was given or full commit hash if full
        or short commit hash was given.

        :param branch_or_commit: string containing branch or full commit hash or short commit hash
        :type branch_or_commit: str

        :rtype str
        """
        url = urljoin(self.rest_api_v1_url, 'commits/{}'.format(branch_or_commit))
        resp = self.session.get(url, headers=self.auth_headers, params={'fields': 'id'})
        resp.raise_for_status()
        data = resp.json().get('data')
        if data and data.get('id'):
            return data.get('id')
        return None
