import logging

from .executor import execute


def get_porto_layers(working_dir, stripped=False, bazel_target=None):
    logging.info('Obtaining porto layers through binaries API')
    cli_args = ['--stripped', str(stripped)]
    if bazel_target:
        cli_args.extend(['--bazel-target', bazel_target])
    porto_layers = execute(working_dir, 'workspace.porto.layers', cli_args).result()
    logging.info(porto_layers)
    return porto_layers
