from sandbox import sdk2
from sandbox.common.patterns import classproperty
from sandbox.projects.sdc.resource_types import SdcFrequentBazelArtifacts, SdcLxcContainer
from sandbox.common.types.resource import State


class LastLxcContainerResource(sdk2.parameters.Container):
    resource_type = SdcLxcContainer

    @classproperty
    def default_value(cls):
        last_resource = cls.resource_type.find(
            type=cls.resource_type,
            attrs={'released': 'stable'},
            state=State.READY,
            limit=1,
        ).first()
        if last_resource:
            return last_resource.id
        else:
            return None


class LastFrequentBazelArtifacts(sdk2.parameters.Resource):
    resource_type = SdcFrequentBazelArtifacts

    @classproperty
    def default_value(cls):
        last_resource = cls.resource_type.find(
            type=cls.resource_type,
            state=State.READY,
            limit=1,
        ).first()
        if last_resource:
            return last_resource.id
        else:
            return None
