import re

from sandbox.projects.sdc.common import arc
from sandbox.projects.sdc.common import arcanum
from sandbox.projects.sdc.common import bitbucket
from sandbox.projects.sdc.common import constants


class VcsService:

    def __init__(self,
                 vcs_type,
                 arc_token=None,
                 arcanum_token=None,
                 bb_token=None,
                 bb_server_url=None):
        self.vcs_type = vcs_type
        self.arc_cli = arc.build_client(arc_token)
        self.arcanum_client = arcanum.ArcanumClient(arcanum_token)
        self.bitbucket_client = bitbucket.BitbucketClient(bb_token, bb_server_url)

    def get_commit_from_branch_or_commit(self, branch_or_commit):
        if self.vcs_type == constants.VCS_ARC:
            return arc.get_commit(self.arc_cli, branch_or_commit)
        else:
            return self.bitbucket_client.get_commit_from_branch_or_commit(branch_or_commit)

    def resolve_branch_and_commit(self, branch_or_commit):
        branch_or_commit = self.clear_branch_or_commit(branch_or_commit)
        if ',' in branch_or_commit:
            branch, commit_candidate = branch_or_commit.rsplit(',', 1)
            commit = self.get_commit_from_branch_or_commit(commit_candidate)
            assert commit.startswith(commit_candidate)
            return True, branch, commit

        commit = self.get_commit_from_branch_or_commit(branch_or_commit, )
        if not commit.startswith(branch_or_commit) and not re.match(r'^r\d+$', branch_or_commit):
            return True, branch_or_commit, commit
        else:
            return False, None, commit

    def clear_branch_or_commit(self, branch_or_commit):
        prefix = 'arcadia/' if self.vcs_type == constants.VCS_ARC else 'origin/'

        result = branch_or_commit
        if branch_or_commit.startswith(prefix):
            result = branch_or_commit[len(prefix):]

        return result
