import logging

from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.projects.sdc.resource_types import SdcLxcContainerWithDocker
from sandbox.projects.sdc.common.docker import login_to_docker
from sandbox.projects.sdc.common.utils import run_command
from sandbox.projects.sdc.common_tasks.BaseSdcTask import BaseSdcTask

log = logging.getLogger(__name__)


class BaseSdcTaskWithDocker(BaseSdcTask):

    class Parameters(BaseSdcTask.Parameters):
        container = sdk2.parameters.Container(
            'LXC container with Docker',
            resource_type=SdcLxcContainerWithDocker,
        )

    def on_save(self):
        if not self.Parameters.container:
            self.Parameters.container = SdcLxcContainerWithDocker.find(
                attrs={"released": "stable"},
                state=(State.READY, ),
            ).first().id

    def prepare_docker(self):
        login_to_docker(self, self.Parameters.username, self.registry_token)
        run_command(self, ['docker', 'info'])
        run_command(self, ['docker', 'image', 'list'])
