import logging

from sandbox.common.types.misc import NotExists
from sandbox.projects.sdc.common_tasks.HitmanRunnerTask import HitmanRunnerTask
from sandbox.projects.sdc.SdcStopTeamcityBuilds import SdcStopTeamcityBuilds


class SdcRunSimMetrics(HitmanRunnerTask):
    def on_break(self, prev_status, status):
        super(SdcRunSimMetrics, self).on_break(prev_status, status)
        if self.Context.job_id != NotExists:
            # we need to stop TC builds, which was started by nirvana graph, since we dont have
            # a native way to cancel them on graph cancelling
            SdcStopTeamcityBuilds(
                self, nirvana_workflow_id=self.Context.nirvana_workflow_id
            ).enqueue()
        else:
            logging.info('Hitman job wasnt started')
