# -*- coding: utf-8 -*-

from sandbox import sdk2

sdc_releasers = [
    'kmeaw',
    'kuddai',
    'antonchek',
    'gorshkovna',
    'ilzar',
]

sdc_ci_releasers = [
    'gorshkovna',
    'ilzar',
    'markperez',
    'artyrian',
    'proskurnev',
]

sdc_qatools_releasers = [
    'alkedr',
    'electricsheep',
    'osado',
    'bulletwow',
    'robot-simulator',
]

sdc_labeling_releasers = [
    'loudhorr',
    'onurtdinov',
    'fwiffo',
    'robot-sdc-labeling',
]

sdc_logs_team_releasers = [
    'esmukov',
    'robot-sdc-logcontrol',
    'rusabakumov',
    'ya-egor',
]

sdc_simulator_releasers = [
    'alkedr',
    'bad-robot',
    'dzhiblavi',
    'electricsheep',
    'osado',
    'robot-simulator',
    'bulletwow',
]

sdg_slack_unfurla_releasers = [
    'esmukov',
    'rusabakumov',
    'ya-egor',
]


class SdcRosbagDecoder(sdk2.Resource):
    """
    Binary for rosbaf files encoding
    """
    releasable = True
    any_arch = False
    releasers = sdc_releasers
    executable = True
    auto_backup = True


class SdcRosbagDecodedJsonFile(sdk2.Resource):
    """
    Encoded rosbag json file
    """
    releasable = True
    any_arch = False
    releasers = sdc_releasers
    auto_backup = True


class SdcBinariesArchive(sdk2.Resource):
    """
    Sdc binary
    """
    releasable = True
    any_arch = False
    releasers = sdc_qatools_releasers
    __default_attribute__ = sdk2.parameters.String


class SdcImportantLogs(sdk2.Resource):
    """
    Sdc logs to investigate if teamcity or bb has some fails
    """
    __default_attribute__ = sdk2.parameters.String


class SdcDockerImageTar(sdk2.Resource):
    """
    Tar archive with docker image made with docker save
    """
    releasable = True
    any_arch = False
    releasers = sdc_ci_releasers


class SdcFrequentBazelArtifacts(sdk2.Resource):
    """
    Frequently used cas artifacts
    """
    releasable = True
    any_arch = True
    releasers = sdc_ci_releasers


class SdcResourcesArchive(sdk2.Resource):
    """
    Squashfs with resources
    """
    releasable = True
    any_arch = False
    releasers = sdc_ci_releasers
    with_test_resources = sdk2.parameters.Bool('Bazel test resources are included', default=False)


class SdcBasePortoLayerYTPath(sdk2.Resource):
    """
    YT path to base porto layer
    Ubuntu Xenial: //home/selfdriving/porto_layers/ubuntu-xenial-base.tar.xz
    Ubuntu Bionic: //home/selfdriving/porto_layers/ubuntu-bionic-base.tar.xz
    """
    __default_attribute__ = sdk2.parameters.String


class SdcJobLayerYtPath(sdk2.Resource):
    """
    YT paths to all porto layers for SDC get porto layers operation in Nirvana
    """
    __default_attribute__ = sdk2.parameters.JSON


class SdcBinariesLayerLogs(sdk2.Resource):
    """
    Important logs for binaries porto layer
    """
    __default_attribute__ = sdk2.parameters.String


class SdcSyncPackagesLayerLogs(sdk2.Resource):
    """
    Important logs for sync packages porto layer
    """
    __default_attribute__ = sdk2.parameters.String


class SdcPortoLayersCommit(sdk2.Resource):
    """
    Commit for which porto layers were built
    """
    __default_attribute__ = sdk2.parameters.String


class SdcWebSimulatorBinariesArchive(sdk2.Resource):
    releasable = True
    releasers = sdc_simulator_releasers


class SdcOfflineTracerApi(sdk2.Resource):
    releasable = True
    releasers = sdc_simulator_releasers


class SdcLxcContainer(sdk2.service_resources.LxcContainer):
    releasers = sdc_ci_releasers


class SdcLxcContainerWithDocker(SdcLxcContainer):
    releasers = sdc_ci_releasers


class SdcLxcContainerCI(sdk2.service_resources.LxcContainer):
    releasers = sdc_ci_releasers


class SdcLanesMapValidatorBinaries(sdk2.Resource):
    """
    Binaries of Lanes Map Validator for maps-editor service. SDC-59876
    """
    releasable = True
    releasers = [
        'ahuk',
        'ilzar',
        'lu4ik',
        'robot-nosecone',
        'sergeynorin',
        'super-sk',
        'tonynovi',
    ]


class SdcLanesRoutingServerBinaries(sdk2.Resource):
    """
    Binaries for Lanes Routing Server. SDC-56257
    """
    releasable = True
    releasers = [
        'amareelez',
        'ilzar',
        'robot-nosecone',
        'allobanov'
    ]


class SdcLabelingStorageBackend(sdk2.Resource):
    """
    Binary for Labeling Storage. SDC-60660
    """
    any_arch = False
    releasable = True
    releasers = sdc_labeling_releasers


class SdcOpenvpnServer(sdk2.Resource):
    """
    Package with OpenVPN Server. SDC-60472
    """
    any_arch = False
    releasable = True
    releasers = ["SDC-INFRA"]


class SdcRtlogsbBackend(sdk2.Resource):
    """
    Binary for rtlogsb. SDC-61359
    """
    any_arch = False
    releasable = True
    releasers = sdc_logs_team_releasers


class SdgSlackUnfurla(sdk2.Resource):
    """
    Binary for slack-unfurla. SDC-70367
    """
    any_arch = False
    releasable = True
    releasers = sdg_slack_unfurla_releasers


class SdgUstanovkiBackend(sdk2.Resource):
    """
    Binary for ustanovki-backend. SDC-88546
    """
    any_arch = False
    releasable = True
    releasers = sdc_logs_team_releasers


class SdgS3auth(sdk2.Resource):
    """
    Binary for s3auth. SDC-95021
    """
    any_arch = False
    releasable = True
    releasers = sdc_logs_team_releasers


class SdgLogRequest(sdk2.Resource):
    """
    Binary for LogRequest service. SDC-94977
    """
    any_arch = False
    releasable = True
    releasers = sdc_logs_team_releasers
