# coding=utf-8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.projects.sdc.simulator.SdcSimulatorRunProgram import (
    SdcSimulatorRunProgram,
    CommonParameters,
)


class SdcSimulatorBuildYaviz(SdcSimulatorRunProgram):
    class Parameters(CommonParameters):
        kill_timeout = 19 * 60 * 60

        with sdk2.parameters.Group('Script parameters') as script_parameters:
            api = sdk2.parameters.String('Simulator api', required=True, default='https://simulator.sdc.yandex-team.ru')
            workers = sdk2.parameters.Integer('Parallel workers', required=True, default=8)
            yt_pool = sdk2.parameters.String('YT pool', required=True, default='selfdriving-metrics')

    @property
    def program(self):
        return 'python3 -m simulator.pool.visualization.build_yaviz_from_ride --api {api} --yt-proxy hahn --workers {workers}'.format(
            api=self.Parameters.api,
            workers=self.Parameters.workers,
        )

    @property
    def env_vars(self):
        return {
            'YT_POOL': self.Parameters.yt_pool,
            'YT_REQUEST_TIMEOUT': 60000,
        }
