# coding=utf-8
from __future__ import unicode_literals

from sandbox import sdk2
from sandbox.projects.sdc.simulator.SdcSimulatorRunProgram import (
    SdcSimulatorRunProgram,
    CommonParameters,
)
from sandbox.projects.sdc.simulator.utils import SECRET_ID


STABLE_COMMIT = 'a1db50c479ec5bf72a10c6bb3e5e4c78526a414e'


class SdcSimulatorCiRunProcess(SdcSimulatorRunProgram):
    STABLE_COMMIT = STABLE_COMMIT

    class Context(SdcSimulatorRunProgram.Context):
        baseline_commit = None
        interest_commit = None

    class Parameters(CommonParameters):
        kill_timeout = 18 * 60 * 60

        use_stable = sdk2.parameters.Bool('Use stable program commit', default=True, description=STABLE_COMMIT)
        with use_stable.value[False]:
            binaries_branch_or_commit = sdk2.parameters.String('Binaries branch or commit hash', default='trunk')

        program_output_path = sdk2.parameters.String('Relative to SDC_ROOT file/dir path with output', default='ci_run_process_output.json')
        output_as_parameter = sdk2.parameters.Bool('Save output in output parameter instead of resource', default=True)

        with output_as_parameter.value[True]:
            output_is_json = sdk2.parameters.Bool('Output is JSON', default=True)

        with sdk2.parameters.Group('Script parameters') as script_parameters:
            process_id = sdk2.parameters.String('Process', required=True)
            process_version = sdk2.parameters.String('Process version')

            source_id = sdk2.parameters.String('CI source')

            baseline_commit = sdk2.parameters.String('Baseline commit')
            baseline_branch = sdk2.parameters.String('Baseline branch', required=True)

            interest_commit = sdk2.parameters.String('Interest commit')
            interest_branch = sdk2.parameters.String('Interest branch', required=True)

    @property
    def program(self):
        program = (
            'python3 -m simulator.pool.ci.run_process'
            ' --execution-type local'
            ' --process-id {process_id}'
            ' --source-id {source_id}'
            ' --baseline-branch {baseline_branch}'
            ' --baseline-commit {baseline_commit}'
            ' --interest-branch {interest_branch}'
            ' --interest-commit {interest_commit}'
        ).format(
            process_id=self.Parameters.process_id,
            source_id=self.Parameters.source_id or self.id,
            baseline_branch=self.Parameters.baseline_branch,
            baseline_commit=self.Context.baseline_commit,
            interest_branch=self.Parameters.interest_branch,
            interest_commit=self.Context.interest_commit,
        )
        return program

    @property
    def env_vars(self):
        env_vars = {
            'T__SECRET__ISOLATE_CLOUD_TOKEN': '{}#ISOLATE_CLOUD_TOKEN'.format(SECRET_ID),
            'ARC_TOKEN': '{}#ARC_TOKEN'.format(SECRET_ID),
        }
        return env_vars

    def on_execute(self):
        with self.memoize_stage.resolve_branches(commit_on_entrance=False):
            if not self.Parameters.baseline_commit:
                baseline_commit = self.vcs_client.get_commit_from_branch_or_commit(self.Parameters.baseline_branch)
            else:
                baseline_commit = self.Parameters.baseline_commit
            if not self.Parameters.interest_commit:
                interest_commit = self.vcs_client.get_commit_from_branch_or_commit(self.Parameters.interest_branch)
            else:
                interest_commit = self.Parameters.interest_commit

            self.Context.baseline_commit = baseline_commit
            self.Context.interest_commit = interest_commit
            self.Context.save()

        self.prepare_binaries(self.Context.baseline_commit, self.Parameters.baseline_branch)
        self.prepare_binaries(self.Context.interest_commit, self.Parameters.interest_branch)

        SdcSimulatorRunProgram.on_execute(self)
